CREATE TABLE  IF NOT EXISTS public.dashboard_savepoints (
	id bigserial NOT NULL,
	dashboard_id bigint NULL,
	dtinc timestamp without time zone DEFAULT current_timestamp NULL,
	users_id bigint NULL,
	dashboardcode varchar NULL,
	CONSTRAINT dashboard_savepoints_pk PRIMARY KEY (id),
	CONSTRAINT dashboard_savepoints_dashboard_fk FOREIGN KEY (dashboard_id) REFERENCES public.dashboard(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT dashboard_savepoints_users_fk FOREIGN KEY (users_id) REFERENCES public.users(id) ON DELETE SET NULL ON UPDATE CASCADE
);
CREATE INDEX  IF NOT EXISTS dashboard_savepoints_dashboard_id_idx ON public.dashboard_savepoints (dashboard_id,dtinc);


CREATE TABLE  IF NOT EXISTS public.dashboard_savepoints_widget (
	id bigserial NOT NULL,
	dashboard_id bigint NULL,
	dashboard_savepoints_id bigint NULL,
	dashboard_widget_id bigint NULL,
	jsonsavepoint jsonb NULL,
	CONSTRAINT dashboard_savepoints_widget_pk PRIMARY KEY (id),
	CONSTRAINT dashboard_savepoints_widget_dashboard_fk FOREIGN KEY (dashboard_id) REFERENCES public.dashboard(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT dashboard_savepoints_widget_dashboard_widget_fk FOREIGN KEY (dashboard_widget_id) REFERENCES public.dashboard_widget(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT dashboard_savepoints_widget_dashboard_savepoints_fk FOREIGN KEY (dashboard_savepoints_id) REFERENCES public.dashboard_savepoints(id) ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE  IF NOT EXISTS public.tasks_savepoints (
	id bigserial NOT NULL,
	tasks_id bigint NULL,
	dtinc timestamp without time zone DEFAULT current_timestamp NULL,
	users_id bigint NULL,
	jsonsavepoints jsonb NULL,
	CONSTRAINT tasks_savepoints_pk PRIMARY KEY (id),
	CONSTRAINT tasks_savepoints_tasks_fk FOREIGN KEY (tasks_id) REFERENCES public.tasks(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT tasks_savepoints_users_fk FOREIGN KEY (users_id) REFERENCES public.users(id) ON DELETE CASCADE ON UPDATE CASCADE
);


CREATE TABLE  IF NOT EXISTS public.report_savepoints (
	id bigserial NOT NULL,
	report_id bigint NULL,
	dtinc timestamp without time zone DEFAULT current_timestamp NULL,
	users_id bigint NULL,
	jsonsavepoints jsonb NULL,
	CONSTRAINT report_savepoints_pk PRIMARY KEY (id),
	CONSTRAINT report_savepoints_tasks_fk FOREIGN KEY (report_id) REFERENCES public.report(id) ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT report_savepoints_users_fk FOREIGN KEY (users_id) REFERENCES public.users(id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE TABLE  IF NOT EXISTS public.packages (
	id bigserial NOT NULL,
	"name" varchar NULL,
	CONSTRAINT packages_pk PRIMARY KEY (id)
);
CREATE TABLE  IF NOT EXISTS public.packages_objects (
	id bigserial NOT NULL,
	packges_id bigint NULL,
	"type" varchar NULL,
	"sequence" integer NULL,
	table_id bigint NULL,
	binaryfile bytea NULL,
	destinationdirectory varchar NULL,
	CONSTRAINT packages_objects_pk PRIMARY KEY (id),
	CONSTRAINT packages_objects_packages_fk FOREIGN KEY (packges_id) REFERENCES public.packages(id) ON DELETE CASCADE ON UPDATE CASCADE
);
ALTER TABLE public.dashboard_savepoints_widget DROP CONSTRAINT dashboard_savepoints_widget_dashboard_widget_fk;
