


CREATE TABLE IF NOT EXISTS public.companies (
    id bigint NOT NULL,
    name character varying,
    registrationnumber character varying,
    address character varying,
    city character varying,
    state character varying,
    country character varying,
    externalcompany character varying,
    date_insert timestamp without time zone DEFAULT now(),
    date_update timestamp without time zone,
    date_deleted timestamp without time zone,
    deleted boolean DEFAULT false
);


--
-- TOC entry 218 (class 1259 OID 16402)
-- Name: companies_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE IF NOT EXISTS public.companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5048 (class 0 OID 0)
-- Dependencies: 218
-- Name: companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.companies_id_seq OWNED BY public.companies.id;


--
-- TOC entry 219 (class 1259 OID 16403)
-- Name: dashboard; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE IF NOT EXISTS  public.dashboard (
    id bigint NOT NULL,
    name character varying,
    groupname character varying,
    dashboardcode character varying,
    description character varying,
    primarydash boolean DEFAULT true,
    public boolean DEFAULT false
);


--
-- TOC entry 220 (class 1259 OID 16408)
-- Name: dashboard_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE IF NOT EXISTS  public.dashboard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5049 (class 0 OID 0)
-- Dependencies: 220
-- Name: dashboard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dashboard_id_seq OWNED BY public.dashboard.id;


--
-- TOC entry 221 (class 1259 OID 16409)
-- Name: dashboard_security; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.dashboard_security (
    id bigint NOT NULL,
    dashboard_id bigint,
    users_id bigint,
    usersgroups_id bigint
);


--
-- TOC entry 222 (class 1259 OID 16412)
-- Name: dashboard_security_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.dashboard_security_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5050 (class 0 OID 0)
-- Dependencies: 222
-- Name: dashboard_security_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dashboard_security_id_seq OWNED BY public.dashboard_security.id;


--
-- TOC entry 223 (class 1259 OID 16413)
-- Name: dashboard_widget; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.dashboard_widget (
    id bigint NOT NULL,
    name character varying,
    type character varying,
    dashboard_id bigint,
    title character varying,
    widgetcode character varying,
    sequence integer,
    masterwidget character varying,
    masterwidgetindex integer,
    indent integer DEFAULT 0,
    condition character varying
);


--
-- TOC entry 224 (class 1259 OID 16419)
-- Name: dashboard_widget_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.dashboard_widget_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5051 (class 0 OID 0)
-- Dependencies: 224
-- Name: dashboard_widget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dashboard_widget_id_seq OWNED BY public.dashboard_widget.id;


--
-- TOC entry 225 (class 1259 OID 16420)
-- Name: dynamicdata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.dynamicdata (
    id bigint NOT NULL,
    dynamictypes_id bigint,
    externalid character varying,
    jsondata jsonb,
    date_insert timestamp without time zone DEFAULT now(),
    date_update timestamp without time zone
);


--
-- TOC entry 226 (class 1259 OID 16426)
-- Name: dynamicdata_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.dynamicdata_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5052 (class 0 OID 0)
-- Dependencies: 226
-- Name: dynamicdata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dynamicdata_id_seq OWNED BY public.dynamicdata.id;


--
-- TOC entry 245 (class 1259 OID 33973)
-- Name: dynamictypes_security; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.dynamictypes_security (
    id bigint NOT NULL,
    dynamictypes_id bigint,
    users_id bigint,
    usersgroups_id bigint,
    perform_insert boolean DEFAULT true,
    perform_update boolean DEFAULT true,
    perform_delete boolean DEFAULT true,
    perform_select boolean DEFAULT true
);


--
-- TOC entry 244 (class 1259 OID 33972)
-- Name: dynamicdata_security_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.dynamicdata_security_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5053 (class 0 OID 0)
-- Dependencies: 244
-- Name: dynamicdata_security_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dynamicdata_security_id_seq OWNED BY public.dynamictypes_security.id;


--
-- TOC entry 227 (class 1259 OID 16427)
-- Name: dynamictypes; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.dynamictypes (
    id bigint NOT NULL,
    name character varying,
    type character varying,
    title character varying
);


--
-- TOC entry 5054 (class 0 OID 0)
-- Dependencies: 227
-- Name: COLUMN dynamictypes.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.dynamictypes.type IS 'private;public';


--
-- TOC entry 228 (class 1259 OID 16432)
-- Name: dynamictypes_fields; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.dynamictypes_fields (
    id bigint NOT NULL,
    dynamictypes_id bigint,
    name character varying,
    type character varying,
    numericprecision integer,
    decimalprecision integer,
    sequence integer,
    title character varying,
    showinform boolean DEFAULT true NOT NULL,
    showinbrowser boolean DEFAULT true NOT NULL,
    formconfig character varying,
    browserconfig character varying
);


--
-- TOC entry 229 (class 1259 OID 16439)
-- Name: dynamictypes_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.dynamictypes_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5055 (class 0 OID 0)
-- Dependencies: 229
-- Name: dynamictypes_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dynamictypes_fields_id_seq OWNED BY public.dynamictypes_fields.id;


--
-- TOC entry 230 (class 1259 OID 16440)
-- Name: dynamictypes_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.dynamictypes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5056 (class 0 OID 0)
-- Dependencies: 230
-- Name: dynamictypes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.dynamictypes_id_seq OWNED BY public.dynamictypes.id;


--
-- TOC entry 231 (class 1259 OID 16441)
-- Name: param; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.param (
    key character varying NOT NULL,
    value character varying
);


--
-- TOC entry 253 (class 1259 OID 34131)
-- Name: report; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.report (
    id bigint NOT NULL,
    title character varying,
    pagesize character varying,
    pageorientation character varying,
    pagemargim character varying,
    subtitle character varying,
    bodyhtml character varying,
    parameters character varying,
    name character varying,
    pageheader character varying
);


--
-- TOC entry 255 (class 1259 OID 34141)
-- Name: report_datasource; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.report_datasource (
    id bigint NOT NULL,
    name character varying,
    sqlquery character varying,
    connection character varying,
    sequence integer,
    parameters character varying,
    reportid bigint
);


--
-- TOC entry 254 (class 1259 OID 34140)
-- Name: report_datasource_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.report_datasource_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5057 (class 0 OID 0)
-- Dependencies: 254
-- Name: report_datasource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.report_datasource_id_seq OWNED BY public.report_datasource.id;


--
-- TOC entry 252 (class 1259 OID 34130)
-- Name: report_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5058 (class 0 OID 0)
-- Dependencies: 252
-- Name: report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.report_id_seq OWNED BY public.report.id;


--
-- TOC entry 249 (class 1259 OID 34010)
-- Name: syslog; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.syslog (
    id bigint NOT NULL,
    dt timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    object jsonb
);


--
-- TOC entry 248 (class 1259 OID 34009)
-- Name: syslog_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.syslog_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5059 (class 0 OID 0)
-- Dependencies: 248
-- Name: syslog_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.syslog_id_seq OWNED BY public.syslog.id;


--
-- TOC entry 241 (class 1259 OID 33945)
-- Name: tasks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.tasks (
    id bigint NOT NULL,
    name character varying,
    parameters character varying,
    command character varying,
    active boolean DEFAULT true NOT NULL,
    api boolean,
    title character varying
);


--
-- TOC entry 240 (class 1259 OID 33944)
-- Name: tasks_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE IF NOT EXISTS  public.tasks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5060 (class 0 OID 0)
-- Dependencies: 240
-- Name: tasks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.tasks_id_seq OWNED BY public.tasks.id;


--
-- TOC entry 243 (class 1259 OID 33955)
-- Name: tasks_schedule; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.tasks_schedule (
    id bigint NOT NULL,
    tasks_id bigint,
    description character varying,
    parametersvalues character varying,
    active boolean DEFAULT false NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    year character varying,
    month character varying,
    day character varying,
    day_of_week character varying,
    hour character varying,
    minute character varying,
    second character varying
);


--
-- TOC entry 242 (class 1259 OID 33954)
-- Name: tasks_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.tasks_schedule_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5061 (class 0 OID 0)
-- Dependencies: 242
-- Name: tasks_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.tasks_schedule_id_seq OWNED BY public.tasks_schedule.id;


--
-- TOC entry 247 (class 1259 OID 33988)
-- Name: tasks_security; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.tasks_security (
    id bigint NOT NULL,
    tasks_id bigint,
    users_id bigint,
    usersgroups_id bigint
);


--
-- TOC entry 246 (class 1259 OID 33987)
-- Name: tasks_security_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.tasks_security_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5062 (class 0 OID 0)
-- Dependencies: 246
-- Name: tasks_security_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.tasks_security_id_seq OWNED BY public.tasks_security.id;


--
-- TOC entry 232 (class 1259 OID 16446)
-- Name: users; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.users (
    id bigint NOT NULL,
    login character varying NOT NULL,
    password character varying,
    type character varying,
    fullname character varying,
    date_insert timestamp without time zone DEFAULT now(),
    date_update timestamp without time zone,
    externaluser character varying,
    active boolean DEFAULT true NOT NULL,
    dashboarddefault_id bigint
);


--
-- TOC entry 5063 (class 0 OID 0)
-- Dependencies: 232
-- Name: COLUMN users.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.type IS 'User;Admin;Super-Admin';


--
-- TOC entry 5064 (class 0 OID 0)
-- Dependencies: 232
-- Name: COLUMN users.externaluser; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.users.externaluser IS 'identificacao usuário externo';


--
-- TOC entry 233 (class 1259 OID 16453)
-- Name: users_companies; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.users_companies (
    users_id bigint,
    companies_id bigint,
    id bigint NOT NULL
);


--
-- TOC entry 234 (class 1259 OID 16456)
-- Name: users_companies_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.users_companies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5065 (class 0 OID 0)
-- Dependencies: 234
-- Name: users_companies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.users_companies_id_seq OWNED BY public.users_companies.id;


--
-- TOC entry 235 (class 1259 OID 16457)
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE IF NOT EXISTS  public.users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5066 (class 0 OID 0)
-- Dependencies: 235
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- TOC entry 236 (class 1259 OID 16458)
-- Name: users_usersgroups; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.users_usersgroups (
    users_id bigint NOT NULL,
    usersgroups_id bigint NOT NULL,
    id bigint NOT NULL
);


--
-- TOC entry 237 (class 1259 OID 16461)
-- Name: users_usersgroups_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.users_usersgroups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5067 (class 0 OID 0)
-- Dependencies: 237
-- Name: users_usersgroups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.users_usersgroups_id_seq OWNED BY public.users_usersgroups.id;


--
-- TOC entry 238 (class 1259 OID 16462)
-- Name: usersgroups; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE  IF NOT EXISTS public.usersgroups (
    id bigint NOT NULL,
    name character varying,
    externalgroup character varying,
    date_insert timestamp without time zone DEFAULT now(),
    date_update timestamp without time zone,
    date_deleted timestamp without time zone,
    deleted boolean DEFAULT false
);


--
-- TOC entry 239 (class 1259 OID 16469)
-- Name: usersgroups_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE  IF NOT EXISTS public.usersgroups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 5068 (class 0 OID 0)
-- Dependencies: 239
-- Name: usersgroups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.usersgroups_id_seq OWNED BY public.usersgroups.id;



--
-- TOC entry 5069 (class 0 OID 0)
-- Dependencies: 250
-- Name: db_connection_id_seq; Type: SEQUENCE OWNED BY; Schema: x_link; Owner: -
--


ALTER TABLE ONLY public.companies ALTER COLUMN id SET DEFAULT nextval('public.companies_id_seq'::regclass);


--
-- TOC entry 4790 (class 2604 OID 16471)
-- Name: dashboard id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard ALTER COLUMN id SET DEFAULT nextval('public.dashboard_id_seq'::regclass);


--
-- TOC entry 4793 (class 2604 OID 16472)
-- Name: dashboard_security id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_security ALTER COLUMN id SET DEFAULT nextval('public.dashboard_security_id_seq'::regclass);


--
-- TOC entry 4794 (class 2604 OID 16473)
-- Name: dashboard_widget id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_widget ALTER COLUMN id SET DEFAULT nextval('public.dashboard_widget_id_seq'::regclass);


--
-- TOC entry 4796 (class 2604 OID 16474)
-- Name: dynamicdata id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamicdata ALTER COLUMN id SET DEFAULT nextval('public.dynamicdata_id_seq'::regclass);


--
-- TOC entry 4798 (class 2604 OID 16475)
-- Name: dynamictypes id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes ALTER COLUMN id SET DEFAULT nextval('public.dynamictypes_id_seq'::regclass);


--
-- TOC entry 4799 (class 2604 OID 16476)
-- Name: dynamictypes_fields id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_fields ALTER COLUMN id SET DEFAULT nextval('public.dynamictypes_fields_id_seq'::regclass);


--
-- TOC entry 4814 (class 2604 OID 33976)
-- Name: dynamictypes_security id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_security ALTER COLUMN id SET DEFAULT nextval('public.dynamicdata_security_id_seq'::regclass);


--
-- TOC entry 4823 (class 2604 OID 34134)
-- Name: report id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report ALTER COLUMN id SET DEFAULT nextval('public.report_id_seq'::regclass);


--
-- TOC entry 4824 (class 2604 OID 34144)
-- Name: report_datasource id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_datasource ALTER COLUMN id SET DEFAULT nextval('public.report_datasource_id_seq'::regclass);


--
-- TOC entry 4820 (class 2604 OID 34013)
-- Name: syslog id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.syslog ALTER COLUMN id SET DEFAULT nextval('public.syslog_id_seq'::regclass);


--
-- TOC entry 4810 (class 2604 OID 33948)
-- Name: tasks id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks ALTER COLUMN id SET DEFAULT nextval('public.tasks_id_seq'::regclass);


--
-- TOC entry 4812 (class 2604 OID 33958)
-- Name: tasks_schedule id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks_schedule ALTER COLUMN id SET DEFAULT nextval('public.tasks_schedule_id_seq'::regclass);


--
-- TOC entry 4819 (class 2604 OID 33991)
-- Name: tasks_security id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks_security ALTER COLUMN id SET DEFAULT nextval('public.tasks_security_id_seq'::regclass);


--
-- TOC entry 4802 (class 2604 OID 16477)
-- Name: users id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- TOC entry 4805 (class 2604 OID 16478)
-- Name: users_companies id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_companies ALTER COLUMN id SET DEFAULT nextval('public.users_companies_id_seq'::regclass);


--
-- TOC entry 4806 (class 2604 OID 16479)
-- Name: users_usersgroups id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_usersgroups ALTER COLUMN id SET DEFAULT nextval('public.users_usersgroups_id_seq'::regclass);


--
-- TOC entry 4807 (class 2604 OID 16480)
-- Name: usersgroups id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.usersgroups ALTER COLUMN id SET DEFAULT nextval('public.usersgroups_id_seq'::regclass);


--
-- TOC entry 4822 (class 2604 OID 34097)
-- Name: db_connection id; Type: DEFAULT; Schema: x_link; Owner: -
--


ALTER TABLE ONLY public.companies
    ADD CONSTRAINT companies_pk PRIMARY KEY (id);


--
-- TOC entry 4828 (class 2606 OID 16487)
-- Name: dashboard dashboard_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard
    ADD CONSTRAINT dashboard_pk PRIMARY KEY (id);


--
-- TOC entry 4830 (class 2606 OID 16489)
-- Name: dashboard_security dashboard_security_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_security
    ADD CONSTRAINT dashboard_security_pk PRIMARY KEY (id);


--
-- TOC entry 4832 (class 2606 OID 16491)
-- Name: dashboard_widget dashboard_widget_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_widget
    ADD CONSTRAINT dashboard_widget_pk PRIMARY KEY (id);


--
-- TOC entry 4834 (class 2606 OID 16493)
-- Name: dashboard_widget dashboard_widget_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_widget
    ADD CONSTRAINT dashboard_widget_unique UNIQUE (dashboard_id, name);


--
-- TOC entry 4836 (class 2606 OID 16495)
-- Name: dynamicdata dynamicdata_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamicdata
    ADD CONSTRAINT dynamicdata_pk PRIMARY KEY (id);


--
-- TOC entry 4866 (class 2606 OID 33981)
-- Name: dynamictypes_security dynamicdata_security_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_security
    ADD CONSTRAINT dynamicdata_security_pk PRIMARY KEY (id);


--
-- TOC entry 4840 (class 2606 OID 16497)
-- Name: dynamictypes_fields dynamictypes_fields_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_fields
    ADD CONSTRAINT dynamictypes_fields_pk PRIMARY KEY (id);


--
-- TOC entry 4842 (class 2606 OID 16499)
-- Name: dynamictypes_fields dynamictypes_fields_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_fields
    ADD CONSTRAINT dynamictypes_fields_unique UNIQUE (dynamictypes_id, name);


--
-- TOC entry 4838 (class 2606 OID 16501)
-- Name: dynamictypes dynamictypes_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes
    ADD CONSTRAINT dynamictypes_pk PRIMARY KEY (id);


--
-- TOC entry 4844 (class 2606 OID 16503)
-- Name: param param_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.param
    ADD CONSTRAINT param_pk PRIMARY KEY (key);


--
-- TOC entry 4882 (class 2606 OID 34148)
-- Name: report_datasource report_datasource_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_datasource
    ADD CONSTRAINT report_datasource_pk PRIMARY KEY (id);


--
-- TOC entry 4884 (class 2606 OID 34155)
-- Name: report_datasource report_datasource_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_datasource
    ADD CONSTRAINT report_datasource_unique UNIQUE (name, reportid);


--
-- TOC entry 4880 (class 2606 OID 34138)
-- Name: report report_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report
    ADD CONSTRAINT report_pk PRIMARY KEY (id);


--
-- TOC entry 4873 (class 2606 OID 34018)
-- Name: syslog syslog_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.syslog
    ADD CONSTRAINT syslog_pk PRIMARY KEY (id);


--
-- TOC entry 4860 (class 2606 OID 33952)
-- Name: tasks tasks_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks
    ADD CONSTRAINT tasks_pk PRIMARY KEY (id);


--
-- TOC entry 4862 (class 2606 OID 33963)
-- Name: tasks_schedule tasks_schedule_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks_schedule
    ADD CONSTRAINT tasks_schedule_pk PRIMARY KEY (id);


--
-- TOC entry 4868 (class 2606 OID 33993)
-- Name: tasks_security tasks_security_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks_security
    ADD CONSTRAINT tasks_security_pk PRIMARY KEY (id);


--
-- TOC entry 4851 (class 2606 OID 16505)
-- Name: users_companies users_companies_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_companies
    ADD CONSTRAINT users_companies_pk PRIMARY KEY (id);


--
-- TOC entry 4853 (class 2606 OID 16507)
-- Name: users_companies users_companies_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_companies
    ADD CONSTRAINT users_companies_unique UNIQUE (users_id, companies_id);


--
-- TOC entry 4847 (class 2606 OID 16509)
-- Name: users users_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pk PRIMARY KEY (id);


--
-- TOC entry 4849 (class 2606 OID 16511)
-- Name: users users_unique_user; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_unique_user UNIQUE (login);


--
-- TOC entry 4855 (class 2606 OID 16513)
-- Name: users_usersgroups users_usersgroups_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_usersgroups
    ADD CONSTRAINT users_usersgroups_pk PRIMARY KEY (id);


--
-- TOC entry 4857 (class 2606 OID 16515)
-- Name: usersgroups usersgroups_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.usersgroups
    ADD CONSTRAINT usersgroups_pk PRIMARY KEY (id);


--
-- TOC entry 4875 (class 2606 OID 34101)
-- Name: db_connection db_connection_pk; Type: CONSTRAINT; Schema: x_link; Owner: -
--


CREATE INDEX dynamicdata_security_dynamicdata_id_idx ON public.dynamictypes_security USING btree (dynamictypes_id, users_id);


--
-- TOC entry 4864 (class 1259 OID 34002)
-- Name: dynamicdata_security_dynamicdata_id_idx2; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX dynamicdata_security_dynamicdata_id_idx2 ON public.dynamictypes_security USING btree (dynamictypes_id, usersgroups_id);


--
-- TOC entry 4845 (class 1259 OID 33970)
-- Name: param_value_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX param_value_idx ON public.param USING btree (value);


--
-- TOC entry 4878 (class 1259 OID 34139)
-- Name: report_name_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX report_name_idx ON public.report USING btree (name);


--
-- TOC entry 4871 (class 1259 OID 34019)
-- Name: syslog_dt_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX syslog_dt_idx ON public.syslog USING btree (dt);


--
-- TOC entry 4858 (class 1259 OID 33971)
-- Name: tasks_name_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX tasks_name_idx ON public.tasks USING btree (name);


--
-- TOC entry 4869 (class 1259 OID 33999)
-- Name: tasks_security_tasks_id_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tasks_security_tasks_id_idx ON public.tasks_security USING btree (tasks_id, users_id);


--
-- TOC entry 4870 (class 1259 OID 34000)
-- Name: tasks_security_tasks_id_idxx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX tasks_security_tasks_id_idxx ON public.tasks_security USING btree (tasks_id, usersgroups_id);


--
-- TOC entry 4885 (class 2606 OID 16516)
-- Name: dashboard_security dashboard_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_security
    ADD CONSTRAINT dashboard_fk_id FOREIGN KEY (dashboard_id) REFERENCES public.dashboard(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4895 (class 2606 OID 34003)
-- Name: dynamictypes_security dynamictype_security_dynamictypes_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_security
    ADD CONSTRAINT dynamictype_security_dynamictypes_fk FOREIGN KEY (dynamictypes_id) REFERENCES public.dynamictypes(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4889 (class 2606 OID 16521)
-- Name: dynamictypes_fields dynamictypes_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dynamictypes_fields
    ADD CONSTRAINT dynamictypes_fk_id FOREIGN KEY (dynamictypes_id) REFERENCES public.dynamictypes(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4890 (class 2606 OID 16526)
-- Name: users_companies fk_companies_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_companies
    ADD CONSTRAINT fk_companies_id FOREIGN KEY (companies_id) REFERENCES public.companies(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4888 (class 2606 OID 16531)
-- Name: dashboard_widget fk_dasbhoard_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_widget
    ADD CONSTRAINT fk_dasbhoard_id FOREIGN KEY (dashboard_id) REFERENCES public.dashboard(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4891 (class 2606 OID 16536)
-- Name: users_companies fk_users_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_companies
    ADD CONSTRAINT fk_users_id FOREIGN KEY (users_id) REFERENCES public.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4897 (class 2606 OID 34149)
-- Name: report_datasource report_datasource_report_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.report_datasource
    ADD CONSTRAINT report_datasource_report_fk FOREIGN KEY (reportid) REFERENCES public.report(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4894 (class 2606 OID 33964)
-- Name: tasks_schedule tasks_schedule_tasks_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks_schedule
    ADD CONSTRAINT tasks_schedule_tasks_fk FOREIGN KEY (tasks_id) REFERENCES public.tasks(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4896 (class 2606 OID 33994)
-- Name: tasks_security tasks_security_tasks_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks_security
    ADD CONSTRAINT tasks_security_tasks_fk FOREIGN KEY (tasks_id) REFERENCES public.tasks(id);


--
-- TOC entry 4892 (class 2606 OID 16541)
-- Name: users_usersgroups users_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_usersgroups
    ADD CONSTRAINT users_fk_id FOREIGN KEY (users_id) REFERENCES public.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4886 (class 2606 OID 16546)
-- Name: dashboard_security users_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_security
    ADD CONSTRAINT users_fk_id FOREIGN KEY (users_id) REFERENCES public.users(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4893 (class 2606 OID 16551)
-- Name: users_usersgroups usersgroups_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.users_usersgroups
    ADD CONSTRAINT usersgroups_fk_id FOREIGN KEY (usersgroups_id) REFERENCES public.usersgroups(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4887 (class 2606 OID 16556)
-- Name: dashboard_security usersgroups_fk_id; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.dashboard_security
    ADD CONSTRAINT usersgroups_fk_id FOREIGN KEY (usersgroups_id) REFERENCES public.usersgroups(id) ON UPDATE CASCADE ON DELETE CASCADE;


-- Completed on 2024-11-02 22:54:29

--
-- PostgreSQL database dump complete
--

