
ALTER TABLE public.report ADD  IF NOT EXISTS tmpparameters varchar NULL;
ALTER TABLE public.report_datasource ADD  IF NOT EXISTS tmpparameters varchar NULL;
ALTER TABLE public.report_datasource ADD  IF NOT EXISTS tmpsqlquery varchar NULL;
ALTER TABLE public.report ADD  IF NOT EXISTS tmppageheader varchar NULL;
ALTER TABLE public.report ADD  IF NOT EXISTS tmpbodyhtml varchar NULL;

ALTER TABLE public.tasks ADD  IF NOT EXISTS tmpcommand varchar NULL;
ALTER TABLE public.tasks ADD  IF NOT EXISTS tmpparameters varchar NULL;

CREATE TABLE IF NOT EXISTS public.triggers (
	id bigserial NOT NULL,
	connectionname varchar NULL,
	tablename varchar NULL,
	active bool NULL,
	triggername varchar NULL,
	triggercode varchar NULL,
	tmptriggercode varchar NULL,
	before_insert bool NULL,
	before_update bool NULL,
	before_delete bool NULL,
	after_insert bool NULL,
	after_update bool NULL,
	after_delete bool NULL,
	hashowner varchar NULL,
	publicid varchar NULL
);

ALTER TABLE public.triggers ADD CONSTRAINT triggers_pk PRIMARY KEY (id);
CREATE UNIQUE INDEX triggers_connectionname_idx ON public.triggers (connectionname,tablename,triggername);

ALTER TABLE public.triggers ADD IF NOT EXISTS  before_insert bool NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS  before_update bool NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS  before_delete bool NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS  after_insert bool NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS  after_update bool NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS  after_delete bool NULL;

CREATE INDEX  trigger_tablename_idx ON public.triggers (tablename,active,triggername);
CREATE INDEX  trigger_publicid_idx ON public.triggers (publicid);

ALTER TABLE public.dashboard_widget ADD IF NOT EXISTS users_editing_id bigint NULL;
ALTER TABLE public.dashboard_widget ADD IF NOT EXISTS date_last_edit timestamp NULL;
ALTER TABLE public.dashboard_widget ADD IF NOT EXISTS editing bool ;
ALTER TABLE public.report ADD IF NOT EXISTS users_editing_id bigint NULL;
ALTER TABLE public.report ADD IF NOT EXISTS date_last_edit timestamp NULL;
ALTER TABLE public.report_datasource ADD IF NOT EXISTS users_editing_id bigint NULL;
ALTER TABLE public.report_datasource ADD IF NOT EXISTS date_last_edit timestamp NULL;
ALTER TABLE public.tasks ADD IF NOT EXISTS users_editing_id bigint NULL;
ALTER TABLE public.tasks ADD IF NOT EXISTS date_last_edit timestamp NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS users_editing_id bigint NULL;
ALTER TABLE public.triggers ADD IF NOT EXISTS date_last_edit timestamp NULL;
 
CREATE TABLE IF NOT EXISTS public.triggers_savepoints (
	id bigserial NOT NULL,
	trigger_id int8 NULL,
	dtinc timestamp DEFAULT CURRENT_TIMESTAMP NULL,
	users_id int8 NULL,
	jsonsavepoints jsonb NULL,
	CONSTRAINT trigger_savepoints_pk PRIMARY KEY (id)
);


-- public.tasks_savepoints chaves estrangeiras

ALTER TABLE public.triggers_savepoints ADD CONSTRAINT  triggers_savepoints_triggers_fk FOREIGN KEY (trigger_id) REFERENCES public.triggers(id) ON DELETE CASCADE ON UPDATE CASCADE;
ALTER TABLE public.triggers_savepoints ADD CONSTRAINT  triggers_savepoints_users_fk FOREIGN KEY (users_id) REFERENCES public.users(id) ON DELETE CASCADE ON UPDATE CASCADE;